/*
 * Decompiled with CFR 0.152.
 */
package framework.logging;

import framework.logging.DVBTestWriter;
import framework.logging.DisplayWriter;
import framework.logging.FileWriter;
import framework.logging.Level;
import framework.logging.LogWriter;
import framework.logging.LoggerTypes;
import framework.logging.SysOutWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Logger
implements Level,
LoggerTypes {
    private static int currLevelStatus = 0;
    private static boolean on = false;
    private static String lineSeparator = System.getProperty("line.separator");
    private static ArrayList logWriter = null;
    private static boolean callerInfo = false;
    private static final Object LOCK = new Object();
    private static final String PROP_FILE = "BDMV/JAR/88888/logger.properties";
    private static final String OLD_PROP_FILE = "BDMV/JAR/88888/boot.properties";
    private static final String LOG_FILE_NAME = "logger.log";
    private static final String OLD_LOG_FILE_NAME = "core.log";
    private static DisplayWriter dispalyWriter = null;
    private static int fontSize = 12;
    private static long startTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLogging() {
        try {
            System.out.println("-----initLogging");
            Object object = LOCK;
            synchronized (object) {
                Properties properties = Logger.getProperties(PROP_FILE);
                Properties properties2 = Logger.getProperties(OLD_PROP_FILE);
                boolean bl2 = Logger.getProperty("core.logging", properties2).equals("true");
                on = Logger.getProperty("enable.logging", properties).equals("1") || bl2;
                System.out.println("-----Logging on " + on);
                if (on) {
                    currLevelStatus = 0;
                    if (Logger.getProperty("core.logging", properties).equals("1") || bl2) {
                        currLevelStatus |= 1;
                    }
                    System.out.println("-----Core Logging on " + ((currLevelStatus & 1) == 1));
                    if (Logger.getProperty("cross.logging", properties).equals("1")) {
                        currLevelStatus |= 2;
                    }
                    if (Logger.getProperty("common.logging", properties).equals("1")) {
                        currLevelStatus |= 4;
                    }
                    if (Logger.getProperty("sysout.logging", properties).equals("1") || bl2) {
                        Logger.addLogger(new SysOutWriter());
                    }
                    if (Logger.getProperty("display.logging", properties).equals("1")) {
                        dispalyWriter = new DisplayWriter();
                        Logger.addLogger(dispalyWriter);
                        Logger.setupFontSize(properties);
                    }
                    boolean bl3 = Logger.getProperty("file.append", properties).equals("1");
                    if (bl2) {
                        Logger.addLogger(new FileWriter(OLD_LOG_FILE_NAME, bl3));
                    }
                    if (Logger.getProperty("file.logging", properties).equals("1")) {
                        Logger.addLogger(new FileWriter(LOG_FILE_NAME, bl3));
                    }
                    if (Logger.getProperty("dvbtest.logging", properties).equals("1")) {
                        Logger.addLogger(new DVBTestWriter());
                    }
                    callerInfo = Logger.getProperty("callerinfo.logging", properties).equals("1");
                    Logger.setStartTimeToNow();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setStartTimeToNow() {
        startTime = System.currentTimeMillis();
    }

    private static void setupFontSize(Properties properties) {
        String string = Logger.getProperty("display.fontsize", properties);
        int n2 = Integer.parseInt(string);
        if (n2 > 3) {
            fontSize = n2;
        }
    }

    public static void setupDisplay(p p2) {
        if (dispalyWriter != null) {
            dispalyWriter.setup(p2, fontSize);
        }
    }

    private static String getProperty(String string, Properties properties) {
        String string2 = "0";
        if (properties.getProperty(string) != null) {
            string2 = properties.getProperty(string);
        }
        return string2;
    }

    public static void addLogger(LogWriter logWriter) {
        if (Logger.logWriter == null) {
            Logger.logWriter = new ArrayList();
        }
        Logger.logWriter.add(logWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUp() {
        if (logWriter != null) {
            Object object = LOCK;
            synchronized (object) {
                Iterator iterator = ((AbstractList)logWriter).iterator();
                while (iterator.hasNext()) {
                    ((LogWriter)iterator.next()).cleanUp();
                }
            }
        }
        logWriter = null;
    }

    public static void log(int n2, String string, Throwable throwable) {
        if (Logger.shouldLog(n2)) {
            Logger.logMessage(Logger.printInfo(new String[]{string, Logger.stackTraceData(throwable)}));
        }
    }

    public static void log(int n2, String string) {
        if (Logger.shouldLog(n2)) {
            Logger.logMessage(Logger.printInfo(new String[]{string}));
        }
    }

    public static void log(int n2, String string, boolean bl2) {
        if (Logger.shouldLog(n2)) {
            Logger.logMessage(Logger.printInfo(new String[]{string, Logger.booleanToString(bl2)}));
        }
    }

    public static void log(int n2, String string, long l2) {
        if (Logger.shouldLog(n2)) {
            Logger.logMessage(Logger.printInfo(new String[]{string, Logger.longToString(l2)}));
        }
    }

    public static void log(int n2, String string, double d2) {
        if (Logger.shouldLog(n2)) {
            Logger.logMessage(Logger.printInfo(new String[]{string, Logger.doubleToString(d2)}));
        }
    }

    public static void log(int n2, String string, Object object) {
        if (Logger.shouldLog(n2)) {
            Logger.logMessage(Logger.printInfo(new String[]{string, Logger.objectToString(object)}));
        }
    }

    public static void log(int n2, String string, Object object, Object object2) {
        if (Logger.shouldLog(n2)) {
            Logger.logMessage(Logger.printInfo(new String[]{string, Logger.objectToString(object), Logger.objectToString(object2)}));
        }
    }

    public static void log(int n2, String string, Object object, boolean bl2) {
        if (Logger.shouldLog(n2)) {
            Logger.logMessage(Logger.printInfo(new String[]{string, Logger.objectToString(object), Logger.booleanToString(bl2)}));
        }
    }

    public static void log(int n2, String string, long l2, long l3) {
        if (Logger.shouldLog(n2)) {
            Logger.logMessage(Logger.printInfo(new String[]{string, Logger.longToString(l2), Logger.longToString(l3)}));
        }
    }

    public static void log(int n2, String string, Object object, Object object2, Object object3) {
        if (Logger.shouldLog(n2)) {
            Logger.logMessage(Logger.printInfo(new String[]{string, Logger.objectToString(object), Logger.objectToString(object2), Logger.objectToString(object3)}));
        }
    }

    public static void log(int n2, String string, Object object, Object object2, Object object3, Object object4) {
        if (Logger.shouldLog(n2)) {
            Logger.logMessage(Logger.printInfo(new String[]{string, Logger.objectToString(object), Logger.objectToString(object2), Logger.objectToString(object3), Logger.objectToString(object4)}));
        }
    }

    public static void log(int n2, String string, Object object, Object object2, Object object3, long l2) {
        if (Logger.shouldLog(n2)) {
            Logger.logMessage(Logger.printInfo(new String[]{string, Logger.objectToString(object), Logger.objectToString(object2), Logger.objectToString(object3), Logger.longToString(l2)}));
        }
    }

    public static String booleanToString(boolean bl2) {
        return String.valueOf(bl2);
    }

    public static String longToString(long l2) {
        return String.valueOf(l2);
    }

    public static String doubleToString(double d2) {
        return String.valueOf(d2);
    }

    public static String objectToString(Object object) {
        return String.valueOf(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logMessage(String string) {
        Object object = LOCK;
        synchronized (object) {
            Iterator iterator = ((AbstractList)logWriter).iterator();
            if (!callerInfo) {
                while (iterator.hasNext()) {
                    ((LogWriter)iterator.next()).writeString(string);
                }
            } else {
                while (iterator.hasNext()) {
                    ((LogWriter)iterator.next()).writeString(Logger.calledBy(5) + string);
                }
            }
        }
    }

    private static boolean shouldLog(int n2) {
        return on && (n2 & currLevelStatus) == n2 && logWriter != null;
    }

    public static boolean isCommonLoggingOn() {
        return Logger.shouldLog(4);
    }

    public static boolean isCoreLoggingOn() {
        return Logger.shouldLog(1);
    }

    public static boolean isCrossLoggingOn() {
        return Logger.shouldLog(2);
    }

    private static String printInfo(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(System.currentTimeMillis() - startTime).append("]");
        stringBuffer.append(String.valueOf(Thread.currentThread()));
        stringBuffer.append(" ");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static String stackTraceData(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(lineSeparator);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    private static String calledBy(int n2) {
        String string = "";
        int n3 = 0;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            throw new Exception("who");
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
            StringTokenizer stringTokenizer = new StringTokenizer(stringWriter.getBuffer().toString(), lineSeparator);
            int n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                if (++n4 == n2) {
                    string = stringTokenizer.nextToken("(") + ":";
                    n3 = string.indexOf("at") + 3;
                    break;
                }
                stringTokenizer.nextToken();
            }
            printWriter.close();
            return string.substring(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(String string) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(Logger.getFileName(string));
            try {
                properties.load(fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private static String getFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("bluray.vfs.root"));
        stringBuffer.append(File.separator);
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '/') {
                stringBuffer.append(File.separator);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static void setLogLevel(int n2) {
        currLevelStatus = n2;
    }

    public static void setLoggingOn(boolean bl2) {
        on = bl2;
    }

    public static boolean isLoggingOn() {
        return on;
    }
}

